import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Investment } from '@/types';

export const propertyInvestmentDetailsPanel = (id: string): Promise<ApiResponse<Investment>> => {
  return axios.get(`/panel-api/my-investment-project-details?id=${id}`);
};
type QueryFnType = typeof propertyInvestmentDetailsPanel;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyInvestmentDetails = (
  { config, id }: UsePropertyProjectOptions = { id: '1' }
) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-investment-detail'],
    queryFn: () => propertyInvestmentDetailsPanel(id),
  });
};
