import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, PropertyProject } from '@/types';

export const getPropertyDetailWebsite = (id: string): Promise<ApiResponse<PropertyProject>> => {
  return axios.get(`/panel-api/get-property-project-details?property_id=${id}`);
};

type QueryFnType = typeof getPropertyDetailWebsite;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyDetails = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-business-detail'],
    queryFn: () => getPropertyDetailWebsite(id),
  });
};
