import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Listing } from '@/types';

export const getPropertyInvestment = (pagination: PaginationQuery): Promise<Listing[]> => {
  return axios.get(url('/panel-api/get-investment-for-project', pagination));
};
type QueryFnType = typeof getPropertyInvestment;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertyInvestment = ({
  config,
  page_per_data = '10',
  page,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['project-investment-listing'],
    queryFn: () => getPropertyInvestment({ page_per_data, page }),
  });
};
