import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { PropertyProject } from '@/types';

export const getPropertyProject = (
  pagination: PaginationQuery
): Promise<TableResponse<PropertyProject>> => {
  return axios.get(url('admin-api/property-project-list', pagination));
};

type QueryFnType = typeof getPropertyProject;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertyProject = ({
  config,
  page_per_data = '10',
  page,
}: UsePropertyProjectOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['PropertyProject'],
    queryFn: () => getPropertyProject({ page_per_data, page }),
  });
};
