import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, PropertyProject } from '@/types';

export const getPropertyProjectDetail = (id: string): Promise<ApiResponse<PropertyProject>> => {
  return axios.get(`admin-api/property-project-details?project_id=${id}`);
};

type QueryFnType = typeof getPropertyProjectDetail;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyProjectDetails = (
  { config, id }: UsePropertyProjectOptions = { id: '1' }
) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-project-detail'],
    queryFn: () => getPropertyProjectDetail(id),
  });
};
