import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, PropertyProject } from '@/types';

export const getPropertyProjectEdit = (id: string): Promise<ApiResponse<PropertyProject>> => {
  return axios.get(`customer-api/my-property-project-details?project_id=${id}`);
};

type QueryFnType = typeof getPropertyProjectEdit;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyItem = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['propertyEdit-detail'],
    queryFn: () => getPropertyProjectEdit(id),
  });
};
