import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, User } from '@/types';

export const getUser = (id: string): Promise<ApiResponse<User>> => {
  return axios.get(`admin-api/view-user-details?userid=${id}`);
};

type QueryFnType = typeof getUser;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useUserDetails = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['user-detail'],
    queryFn: () => getUser(id),
  });
};
