import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { User } from '@/types/User';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';

export type UpdateBusinessDTO = {
  business_name: string;
  inc: string;
  vat: string;
  country: string;
  personal_phone: string;
  business_phone: string;
  insurance: File;
  certification: File;
};

export const getUsers = (pagination: PaginationQuery): Promise<TableResponse<User>> => {
  return axios.get(url('admin-api/get-customer-list', pagination));
};

type QueryFnType = typeof getUsers;

type UseUsersOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useUsers = ({ config, page_per_data = '10', page }: UseUsersOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['users'],
    queryFn: () => getUsers({ page_per_data, page }),
  });
};
