import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const ReviewRating = (id: any): Promise<ApiResponse<InvestorContent>> => {
  return axios.get(`/customer-api/view-rating-reviews?customer_id=${id}`);
};

type QueryFnType = typeof ReviewRating;

type investorData = {
  config?: QueryConfig<QueryFnType>;
  id?: any;
};

export const useReviewRating = ({ config, id }: investorData = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['content'],
    queryFn: () => ReviewRating(id),
  });
};
