import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Business } from '@/types';

export const viewProfile = ({
  id,
  filter_data,
  subscription_tyre,
  sort_price,
}: {
  id: string;
  min_price: any;
  max_price: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
  type: any;
}): Promise<ApiResponse<Business>> => {
  return axios.get(
    `/customer-api/customer-profile-details?customer_id=${id}&filter_data=true&sort_upload_date=latest&filter_data=${filter_data}&subscription_tyre=${subscription_tyre}&sort_price=${sort_price}`
  );
};

type QueryFnType = typeof viewProfile;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
  min_price: any;
  max_price: any;
  type: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
};

export const useViewProfile = ({
  id,
  config,
  min_price,
  max_price,
  location,
  type,
  bedroom_min,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
}: UseBusinessOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['business-detail'],
    queryFn: () =>
      viewProfile({
        id,
        min_price,
        max_price,
        location,
        bedroom_min,
        bedroom_max,
        amenities,
        filter_data,
        type,
        subscription_tyre,
        sort_price,
      }),
  });
};
