import React, { useEffect, useState } from 'react';
import { CardElement, useStripe, useElements } from '@stripe/react-stripe-js';
import './stripe.css';
import cardpic from '@/assets/cardpic.svg';
import { useNavigate, useParams } from 'react-router-dom';
import { stripeApi } from '@/features/agency/api/Subscription/stripeApi';
import { useNotificationStore } from '@/stores/notifications';

const PaymentForm: React.FC = () => {
  const stripe = useStripe();
  const elements = useElements();
  const [isLoading, setIsLoading] = useState(false);
  const navigate = useNavigate();

  const { id } = useParams();
  const [subscriptionId, setsubscriptionId] = useState<number>(0);
  useEffect(() => {
    if (id) {
      setsubscriptionId(parseInt(id));
    }
  }, [id]);

  const handleSubmit = async (event: React.FormEvent) => {
    event.preventDefault();
    if (!stripe || !elements) {
      return;
    }
    setIsLoading(true);
    const cardElement = elements.getElement(CardElement);
    if (!cardElement) {
      return;
    }
    try {
      // Create a token using a test card
      const { token } = await stripe.createToken(cardElement, {
        currency: 'usd',
        name: 'Dummy User',
        address_line1: '456 Dummy Street',
        address_city: 'Dummy City',
        address_state: 'Dummy State',
        address_country: 'Dummy Country',
        address_zip: '12345',
      });

      if (token) {
        const cardToken = token?.id;
        const data = await stripeApi(subscriptionId, cardToken);
        {
          if (data) {
            navigate('/lawyer/profile');
            useNotificationStore.getState().addNotification({
              title: 'Success',
              type: 'success',
              message: 'Subscription purchased successfully',
            });
          }
        }
      }
    } finally {
      setIsLoading(false);
    }
  };

  return (
    <form onSubmit={handleSubmit} className="payment-form">
      <div className="form-row">
        <img src={cardpic} alt="sd" />
        <label htmlFor="card-element">Card Details</label>
        <CardElement
          id="card-element"
          options={{
            style: {
              base: {
                fontSize: '16px',
                fontFamily: 'Arial, sans-serif',
              },
            },
          }}
        />
        <button type="submit" disabled={!stripe || isLoading} className="pay-button">
          {isLoading ? 'Processing...' : 'Pay'}
        </button>
      </div>
    </form>
  );
};

export default PaymentForm;
