import { Elements } from '@stripe/react-stripe-js';
import { loadStripe } from '@stripe/stripe-js';
import PaymentForm from './PaymentForm';

export const StripePayment = () => {
  const key = process.env.REACT_APP_STRIPE_KEY as string;

  const stripePromise = loadStripe(`${key}`);

  return (
    <>
      <h3 className="pts">Pay Through Stripe</h3>
      <Elements stripe={stripePromise}>
        <PaymentForm />
      </Elements>
    </>
  );
};
