import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { useDisclosure } from '@/hooks/useDisclosure';

import { Button } from '../Button';

import { Dialog, DialogTitle } from './Dialog';

const meta: Meta = {
  title: 'Components/Elements/Dialog',
  component: Dialog,
  parameters: {
    controls: { expanded: true },
  },
};

export default meta;

export const Demo: Story = () => {
  const { close, open, isOpen } = useDisclosure();
  const cancelButtonRef = React.useRef(null);

  return (
    <>
      <Button onClick={open}>Open</Button>
      <Dialog isOpen={isOpen} onClose={close} initialFocus={cancelButtonRef}>
        <div className="inline-block align-top bg-white px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
          <div className="mt-3 sm:mt-0 sm:ml-4 sm:text-left">
            <DialogTitle as="h3" className="text-lg leading-6 font-medium text-gray-900">
              Modal Title
            </DialogTitle>
          </div>
          <div className="mt-2 sm:mt-4 sm:flex sm:flex-row-reverse">
            <Button type="button" onClick={close} ref={cancelButtonRef}>
              Cancel
            </Button>
          </div>
        </div>
      </Dialog>
    </>
  );
};
