import React, { useEffect } from 'react';

import { EditorState } from 'draft-js';
import { Editor } from 'react-draft-wysiwyg';
import 'draft-js/dist/Draft.css';
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css';
import { convertToHTML } from 'draft-convert';
const stateFromHTML = require('draft-js-import-html').stateFromHTML;
const toolbarOptions = {
  options: ['inline', 'list', 'textAlign', 'history'],
  inline: {
    options: ['bold', 'italic', 'underline'],
  },
  blockType: {
    options: ['HeaderThree', 'unordered-list-item'],
  },
  list: {
    options: ['unordered'],
  },
};
function EditDraftInput({ html, setHtml, editorState, setEditorState, stateData }) {
  useEffect(() => {
    if (stateData) {
      setHtml(stateData);
      const contentState = stateFromHTML(stateData);
      const editorState = EditorState.createWithContent(contentState);
      setEditorState(editorState);
    }
  }, [stateData]);
  const handleChange = (state: any) => {
    setEditorState(state);
    convertContentToHTML();
  };

  const convertContentToHTML = () => {
    const currentContentAsHTML = convertToHTML(editorState.getCurrentContent());
    setHtml(currentContentAsHTML);
  };

  return (
    <>
      <Editor
        toolbar={toolbarOptions}
        editorState={editorState}
        onEditorStateChange={handleChange}
      />
    </>
  );
}

export default EditDraftInput;
