/* eslint-disable jsx-a11y/no-noninteractive-element-interactions */
import React, { useEffect, useState } from 'react';
import './DropDown.css';
type DropDownProps = {
  cities: string[];
  showDropDown: boolean;
  toggleDropDown: () => void;
  citySelection: (city: string) => void;
};

const DropDown: React.FC<DropDownProps> = ({
  cities,
  citySelection,
}: DropDownProps): JSX.Element => {
  const [showDropDown, setShowDropDown] = useState<boolean>(false);

  const onClickHandler = (city: string): void => {
    citySelection(city);
  };

  useEffect(() => {
    setShowDropDown(showDropDown);
  }, [showDropDown]);

  return (
    <>
      <div className={showDropDown ? 'dropdown' : 'dropdown active'}>
        {cities.map((city: string, index: number): JSX.Element => {
          return (
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            <p
              key={index}
              onClick={(): void => {
                onClickHandler(city);
              }}
            >
              {city}
            </p>
          );
        })}
      </div>
    </>
  );
};

export default DropDown;
