/* eslint-disable jsx-a11y/no-autofocus */
import React, { LegacyRef, useRef } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Button from '@material-ui/core/Button';
import Dialog from '@material-ui/core/Dialog';
import AppBar from '@material-ui/core/AppBar';
import Toolbar from '@material-ui/core/Toolbar';
import IconButton from '@material-ui/core/IconButton';
import Typography from '@material-ui/core/Typography';
import CloseIcon from '@material-ui/icons/Close';
import Slide from '@material-ui/core/Slide';
import { ImageTag } from './ImageTag';
import './images.css';

const useStyles = makeStyles((theme) => ({
  appBar: {
    position: 'relative',
  },
  title: {
    marginLeft: theme.spacing(2),
    flex: 1,
  },
}));

const Transition = React.forwardRef(function Transition(props: any, ref: any) {
  return <Slide direction="up" ref={ref} {...(props ?? ' ')} />;
});

export default function FullViewer({
  image,
  isOpen,
  close,
}: {
  image?: string;
  isOpen: boolean;
  close: () => void;
}) {
  const classes = useStyles();

  const handleClose = () => {
    close();
  };

  const download = () => {
    const a = document.createElement('a');
    a.setAttribute('href', image ?? '');
    a.setAttribute('download', '');
    a.setAttribute('target', '_blank');
    a.click();
  };

  return (
    <Dialog fullScreen open={isOpen} onClose={handleClose} TransitionComponent={Transition}>
      <AppBar className={classes.appBar}>
        <Toolbar>
          <IconButton
            edge="start"
            color="inherit"
            type="button"
            onClick={handleClose}
            aria-label="close"
          >
            <CloseIcon />
          </IconButton>
          <Typography variant="h6" className={classes.title}>
            View
          </Typography>
          {/* <Button type="button" color="inherit" onClick={download}>
            Download
          </Button> */}
          <Button type="button" autoFocus color="inherit" onClick={handleClose}>
            Close
          </Button>
        </Toolbar>
      </AppBar>
      <ImageTag src={image ?? null} className="fullViewImage" />
    </Dialog>
  );
}
