import React from 'react';

import { useDisclosure } from '@/hooks/useDisclosure';

import FullViewer from './FullViewer';
import { ImageTag } from './ImageTag';

export const Image = (props: any) => {
  const { open, close, isOpen } = useDisclosure();

  return (
    <>
      <ImageTag {...props} openFullSize={() => open()} />
      <FullViewer image={props.src} isOpen={isOpen} close={close} />
    </>
  );
};
