import React from 'react';
import { Skeleton } from '@mui/material';
import './loader.css';
import i18next from 'i18next';

const AdminProfileLoader = () => {
  return (
    <>
      <div className="row align-items-center mt-4">
        <div className="col-8" style={{ marginBottom: '60px' }}>
          <div className="flex gap-4 items-center">
            <Skeleton variant="circular" width={100} height={100} />
            <div>
              <Skeleton variant="rounded" width={210} height={25} />
              <br />
              <Skeleton variant="rounded" width={100} height={30} />
            </div>
          </div>
        </div>
        <div className="col-6">
          <h5>First Name</h5>
          <Skeleton variant="rounded" height={50} />
        </div>
        <div className="col-6">
          <h5>Last Name</h5>
          <Skeleton variant="rounded" height={50} />
        </div>
        <div className="col-6 mt-2">
          <h5>{i18next.t('Phone')}</h5>
          <Skeleton variant="rounded" height={50} />
        </div>
        <div className="col-6 mt-2">
          <h5>{i18next.t('Email')}</h5>
          <Skeleton variant="rounded" height={50} />
        </div>
      </div>
      <div className="flex justify-center mt-4">
        <div className="flex gap-2">
          <Skeleton variant="rounded" width={100} height={50} />
          <Skeleton variant="rounded" width={100} height={50} />
        </div>
      </div>
    </>
  );
};

export default AdminProfileLoader;
