import React from 'react';
import { Skeleton } from '@mui/material';
import './loader.css';
import i18next from 'i18next';

const CompanyLoader = () => {
  return (
    <>
      <div className="profile-box mb-5">
        <div className="row align-items-center">
          <div className="col-3">
            <h5>{i18next.t('Company Name')}</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Company Slug / Url</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Slogan</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Company Category</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Company Email Address</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Company Telephone</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>Company Vision</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
        <div className="row align-items-center field-row">
          <div className="col-3">
            <h5>{i18next.t('Company Details')}</h5>
          </div>
          <div className="col-8 mt-2">
            <Skeleton variant="rectangular" height={50}></Skeleton>
          </div>
        </div>
      </div>
    </>
  );
};

export default CompanyLoader;
