import React, { useState } from 'react';
import DropDown from '../DropDown/DropDown';
import clsx from 'clsx';

const ChooseLocation: React.FC = (): JSX.Element => {
  const [showDropDown, setShowDropDown] = useState<boolean>(false);
  const [selectCity, setSelectCity] = useState<string>('');
  const cities = () => {
    return ['Hong Kong', 'London', 'New York City', 'Paris'];
  };

  const toggleDropDown = () => {
    setShowDropDown(!showDropDown);
  };
  const dismissHandler = (event: React.FocusEvent<HTMLButtonElement>): void => {
    if (event.currentTarget === event.target) {
      setShowDropDown(false);
    }
  };

  const citySelection = (city: string): void => {
    setSelectCity(city);
  };

  return (
    <div className="dd">
      <button
        className={clsx('drops', showDropDown ? 'active' : undefined)}
        onClick={(): void => toggleDropDown()}
        onBlur={(e: React.FocusEvent<HTMLButtonElement>): void => dismissHandler(e)}
      >
        <div>{selectCity ? selectCity : 'Choose Location >'} </div>
        {showDropDown && (
          <DropDown
            cities={cities()}
            showDropDown={false}
            toggleDropDown={(): void => toggleDropDown()}
            citySelection={citySelection}
          />
        )}
      </button>
    </div>
  );
};

export default ChooseLocation;
