import React, { useState } from 'react';
import clsx from 'clsx';
import DropDown from '../DropDown/DropDown';
import './SearchForm.css';
const PropertyStatus: React.FC = (): JSX.Element => {
  const [showDropDown, setShowDropDown] = useState<boolean>(false);
  const [selectCity, setSelectCity] = useState<string>('');
  const cities = () => {
    return ['Commercial', 'Property For Sale', 'Property For Rent', 'Hotels'];
  };

  const toggleDropDown = () => {
    setShowDropDown(!showDropDown);
  };

  const dismissHandler = (event: React.FocusEvent<HTMLButtonElement>): void => {
    if (event.currentTarget === event.target) {
      setShowDropDown(false);
    }
  };

  const citySelection = (city: string): void => {
    setSelectCity(city);
  };

  return (
    <div className="dd">
      <button
        className={clsx('drops', showDropDown ? 'active' : undefined)}
        onClick={(): void => toggleDropDown()}
        onBlur={(e: React.FocusEvent<HTMLButtonElement>): void => dismissHandler(e)}
      >
        <div className="btnDivs">{selectCity ? selectCity : 'Property Status >'} </div>
        {showDropDown && (
          <DropDown
            cities={cities()}
            showDropDown={false}
            toggleDropDown={(): void => toggleDropDown()}
            citySelection={citySelection}
          />
        )}
      </button>
    </div>
  );
};

export default PropertyStatus;
