import React, { useEffect, useState } from 'react';
import { Button } from '@/components/Elements';

import { SelectChangeEvent } from '@mui/material/Select';

import './SearchForm.css';
import { FormControl, InputLabel, MenuItem, Select, TextField } from '@mui/material';

import Menu from '@mui/material/Menu';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import axiosmod from 'axios';
import i18next from 'i18next';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

const SearchForm = ({
  settype,
  setmin_price,
  setmax_price,
  setlocation,
  setSearch,
  setSave,
  setlat,
  setlng,
  setClearSearchVal,
}: {
  settype: (value: string) => void;
  setmin_price: (value: string) => void;
  setmax_price: (value: string) => void;
  setSearch: (value: boolean) => void;
  setSave: (value: boolean) => void;
  setlocation: (value: string) => void;
  setlat: (value: string) => void;
  setlng: (value: string) => void;
  setClearSearchVal: (value: boolean) => void;
}) => {
  const [sale, setSale] = useState('');
  const [minPrice, setMin] = useState();
  const [maxPrice, setMax] = useState();
  const [searchs, setSearchVal] = useState(false);
  const [clears, setClears] = useState(false);
  const [address, setAddress] = useState<string>('');
  const [locationGoogle, setLocationGoogle] = useState();

  const [value, setValue] = useState(null);
  const [latitude, setlatitude] = useState(0);
  const [longitude, setlongitude] = useState(0);

  useEffect(() => {
    if (locationGoogle) {
      setlatitude(locationGoogle?.lat);
      setlongitude(locationGoogle?.lng);
    }
  }, [locationGoogle]);

  // ----------------- Property for sale ----------------------

  const handleChange = (event: SelectChangeEvent) => {
    const selectedSale = event.target.value as string;
    setSale(selectedSale);
    settype(selectedSale);
    handleSearch();
  };

  const handleStartChange = (event: SelectChangeEvent) => {
    const selectedStart = event.target.value;
    setMin(selectedStart);
  };

  const handleEndChange = (event: SelectChangeEvent) => {
    const selectedEnd = event.target.value;
    setMax(selectedEnd);
  };
  //c
  useEffect(() => {
    setmin_price(minPrice);
    setmax_price(maxPrice);
    handleSearch();
  }, [maxPrice, minPrice, setmax_price, setmin_price]);

  useEffect(() => {
    setlat(latitude);
    setlng(longitude);
    setlocation(address);
  }, [address]);

  // ------------------- Menu Bar -------------------

  const [anchorEl, setAnchorEl] = React.useState<null | HTMLElement>(null);

  const open = Boolean(anchorEl);

  const handleClick = (event: React.MouseEvent<HTMLButtonElement>) => {
    const buttonId = event.currentTarget.id;

    if (buttonId === 'basic-button') {
      setAnchorEl(event.currentTarget);
    }
  };

  const handleClose = () => {
    setAnchorEl(null);
  };

  // ------------------ Location ---------------------

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    const addressData = data?.results[0]?.formatted_address;

    if (location) {
      setLocationGoogle(location);
      setValue(value);
    }
    if (addressData) {
      setAddress(addressData);
    }
    handleSearch();
  };
  // ---------------- Submit --------------------
  const handleSearch = () => {
    setSearchVal(!searchs);
  };
  const clearSearch = () => {
    setClears(true);
    setAddress('');
  };

  useEffect(() => {
    if (clears === true) {
      setClearSearchVal(true);
      setMin('');
      setMax('');
      setlatitude('');
      setlongitude('');
      setSale('');
      setAddress('');
      setValue('');
    }
  }, [clears]);

  useEffect(() => {
    setSearch(searchs);
  }, [searchs]);

  // ---------------- Save --------------------
  const handleSave = () => {
    setSave(true);
  };

  return (
    <div className="roundbox searchBar">
      <div className="outer row">
        <div className="left col-12 col-md-12 col-lg-10">
          <div className="row">
            <div className="col-12 col-md-4 col-lg-4 bloks">
              <FormControl fullWidth>
                <InputLabel id="demo-simple-select-label">{i18next.t('Property Type')}</InputLabel>
                <Select
                  labelId="demo-simple-select-label"
                  id="demo-simple-select"
                  value={sale}
                  label={i18next.t('Property Type')}
                  onChange={handleChange}
                >
                  <MenuItem value={''}>{i18next.t('All Properties')}</MenuItem>
                  <MenuItem value={'BusinessSale'}>{i18next.t('Business For Sale')}</MenuItem>
                  <MenuItem value={'SaleProperty'}>{i18next.t('Property For Sale')}</MenuItem>
                  <MenuItem value={'RentProperty'}>{i18next.t('Property For Rent')}</MenuItem>
                  <MenuItem value={'HouseRent'}>{i18next.t('House for rent')}</MenuItem>
                  <MenuItem value={'InvestmentProject'}>{i18next.t('Investment Project')}</MenuItem>
                  <MenuItem value={'InvestmentCompany'}>{i18next.t('Investment Company')}</MenuItem>
                  <MenuItem value={'PropertyProject'}>{i18next.t('Property Project')}</MenuItem>
                </Select>
              </FormControl>
            </div>
            <div className="col-12 col-md-4 col-lg-4  bloks">
              <GooglePlacesAutocomplete
                apiKey={googleMapAPIkey}
                selectProps={{
                  defaultInputValue: '',
                  value,
                  isClearable: true,
                  placeholder: `${i18next.t('Search for city/location')}`,
                  onChange: handleChangeLocation,
                }}
              />
            </div>
            <div className="col-12 col-md-4 col-lg-4  bloks">
              <div className="MenuItemSearch">
                <Button
                  id="basic-button"
                  aria-controls={open ? 'basic-menu' : undefined}
                  aria-haspopup="true"
                  aria-expanded={open ? 'true' : undefined}
                  onClick={handleClick}
                  className="priceButton"
                >
                  {minPrice == null && maxPrice == null ? (
                    `${i18next.t('Price')}`
                  ) : (
                    <>
                      <span>
                        ${minPrice} - ${maxPrice}
                      </span>
                    </>
                  )}
                </Button>
                <Menu
                  id="basic-menu"
                  anchorEl={anchorEl}
                  open={open}
                  onClose={handleClose}
                  MenuListProps={{
                    'aria-labelledby': 'basic-button',
                  }}
                >
                  <div className="jojoDiv">
                    {/* <p>Enter in $ only</p> */}
                    <div className="row">
                      <div className="col-md-6">
                        <TextField
                          type="number"
                          id="outlined-basic"
                          defaultValue={minPrice}
                          onChange={handleStartChange}
                          label={i18next.t('Min')}
                          variant="outlined"
                        />
                      </div>
                      <div className="col-md-6">
                        <TextField
                          type="number"
                          id="outlined-basic"
                          onChange={handleEndChange}
                          defaultValue={maxPrice}
                          label={i18next.t('Max')}
                          variant="outlined"
                        />
                      </div>
                    </div>
                  </div>
                </Menu>
              </div>
            </div>
          </div>
        </div>
        <div className="right col-12 col-md-12 col-lg-2">
          {sale == '' && maxPrice === undefined ? (
            <Button className="btn-rounded bttn" onClick={() => handleSearch()}>
              {i18next.t('Search')}
            </Button>
          ) : (
            <>
              <Button className="btn-rounded bttn" onClick={() => handleSearch()}>
                <i className="fa-solid fa-magnifying-glass whiteColor"></i>
              </Button>
              <button className="saveButton " onClick={() => clearSearch()}>
                <i className="fa-solid fa-xmark "></i>
              </button>
              <button className="saveButton " onClick={() => handleSave()}>
                <i className="fa-regular fa-bookmark"></i>
              </button>
            </>
          )}
        </div>
      </div>
    </div>
  );
};

export default SearchForm;
