import { City } from 'country-state-city';
import React, { useState } from 'react';

interface StateComponentProps {
  onStateChange: (value: string) => void;
  defaultState?: string;
  selectedStateVAl?: any;
  selectedCountryVal?: any;
}

const CityComponent = ({
  onStateChange,
  defaultState,
  selectedStateVAl,
  selectedCountryVal,
}: StateComponentProps) => {
  const [selectedValue, setSelectedValue] = useState(defaultState || '');

  const handleSelectChange = (event: React.ChangeEvent<HTMLSelectElement>) => {
    const selectedValue = event.target.value;
    setSelectedValue(selectedValue);
    onStateChange(selectedValue); // Invoke the callback function with the selected value
  };

  const data = City.getCitiesOfState(selectedCountryVal, selectedStateVAl).map((city) => ({
    value: city.name,
    displayValue:
      defaultState && city.name === defaultState ? `${city.name} (Default)` : `${city.name} `,
  }));

  return (
    <select className="customSelectForm" value={selectedValue} onChange={handleSelectChange}>
      {data?.map((option, index) => (
        <option key={index} value={option.value}>
          {option.displayValue}
        </option>
      ))}
    </select>
  );
};

export default CityComponent;
