import { Country } from 'country-state-city';
import React, { useState } from 'react';

interface CountryComponentProps {
  onCountryChange: (value: string) => void;
  defaultCountry?: string;
}

const CountryComponent = ({ onCountryChange, defaultCountry }: CountryComponentProps) => {
  const [selectedValue, setSelectedValue] = useState(defaultCountry || '');

  const handleSelectChange = (event: React.ChangeEvent<HTMLSelectElement>) => {
    const selectedValue = event.target.value;
    setSelectedValue(selectedValue);
    onCountryChange(selectedValue);
  };

  const countries = Country.getAllCountries().map((country) => ({
    value: country.name,
    displayValue:
      defaultCountry && country.name === defaultCountry
        ? `${country.name} - ${country.isoCode} (Default)`
        : `${country.name} - ${country.isoCode}`,
  }));

  return (
    <select className="customSelectForm" value={selectedValue} onChange={handleSelectChange}>
      {countries.map((option, index) => (
        <option key={index} value={option.value}>
          {option.displayValue}
        </option>
      ))}
    </select>
  );
};

export default CountryComponent;
