import { State } from 'country-state-city';
import React, { useState } from 'react';

interface StateComponentProps {
  onStateChange: (value: string) => void;
  defaultState?: string;
  selectedCountryVal?: any;
}

const StateComponent = ({
  onStateChange,
  defaultState,
  selectedCountryVal,
}: StateComponentProps) => {
  const [selectedValue, setSelectedValue] = useState(defaultState || '');

  const handleSelectChange = (event: React.ChangeEvent<HTMLSelectElement>) => {
    const selectedValue = event.target.value;
    setSelectedValue(selectedValue);
    onStateChange(selectedValue);
  };

  const data = State.getStatesOfCountry(`${selectedCountryVal}`).map((state) => ({
    value: state.name,
    displayValue:
      defaultState && state.name === defaultState
        ? `${state.name} - ${state.isoCode} (Default)`
        : `${state.name} - ${state.isoCode}`,
  }));

  return (
    <select className="customSelectForm" value={selectedValue} onChange={handleSelectChange}>
      {data?.map((option, index) => (
        <option key={index} value={option.value}>
          {option.displayValue}
        </option>
      ))}
    </select>
  );
};

export default StateComponent;
