type EntryProps = {
  label: string;
  value: string;
};
export const Entry = ({ label, value }: EntryProps) => (
  <div className="py-2 my-1 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6 entryField">
    <dt className="font-medium text-gray-700">{label}</dt>
    <dd className="mt-1 text-gray-900 sm:mt-0 sm:col-span-2">{value}</dd>
  </div>
);
