// src/MapComponent.tsx

import React, { useState } from 'react';
import { GoogleMap, Marker, LoadScript } from '@react-google-maps/api';
import { Autocomplete } from '@react-google-maps/api';
import { useRef } from 'react';
import { FieldWrapper } from '@/components/Form/FieldWrapper';
import { UseFormRegisterReturn } from 'react-hook-form';

interface Coordinates {
  lat: number;
  lng: number;
}

interface MapComponentProps {
  coordinates: Coordinates;
}

type AddressParam = {
  address: string;
  location: number[];
  lat: number;
  long: number;
};
type PropsType = {
  label: string;
  handdleAddressChange?: (details: AddressParam) => void;
  error: any;
  registration?: Partial<UseFormRegisterReturn>;
};

export const MapMarker: React.FC<MapComponentProps> = ({ coordinates }) => {
  const mapStyles = {
    height: '400px',
    width: '100%',
  };
  const defaultCenter = {
    lat: coordinates.lat,
    lng: coordinates.lng,
  };
  return (
    <GoogleMap mapContainerStyle={mapStyles} zoom={10} center={defaultCenter}>
      <Marker position={defaultCenter} />
    </GoogleMap>
  );
};

export const LocationInput = (props: PropsType) => {
  const { label, handdleAddressChange, error, registration } = props;
  const autocompleteRef: any = useRef(null);
  const onPlaceChanged = () => {
    if (autocompleteRef.current) {
      const place = autocompleteRef?.current?.getPlace();
      const address = place.formatted_address || '';
      const lat = place?.geometry?.location?.lat();
      const lng = place?.geometry?.location?.lng();
      const details = {
        address,
        location: [lat, lng],
        lat,
        long: lng,
      };
      handdleAddressChange ? handdleAddressChange(details) : null;
    }
  };
  return (
    <FieldWrapper error={error} label={label}>
      <Autocomplete
        onLoad={(autocomplete) => {
          autocompleteRef.current = autocomplete;
        }}
        onPlaceChanged={onPlaceChanged}
      >
        <input
          type="text"
          className="form-control"
          placeholder="Enter address"
          name="streetAddress"
          {...registration}
        />
      </Autocomplete>
    </FieldWrapper>
  );
};

export const MapViwerWithSearch = (props: PropsType) => {
  const { label, handdleAddressChange, error, registration } = props;
  const [cordinates, setCordinates] = useState<Coordinates>({
    lat: 30.71526,
    lng: 76.70777,
  });
  const autocompleteRef: any = useRef(null);
  const onPlaceChanged = () => {
    if (autocompleteRef.current) {
      const place = autocompleteRef?.current?.getPlace();
      const address = place.formatted_address || '';
      const lat = place?.geometry?.location?.lat();
      const lng = place?.geometry?.location?.lng();
      const details = {
        address,
        location: [lat, lng],
        lat,
        long: lng,
      };
      setCordinates({ lat, lng });
      handdleAddressChange ? handdleAddressChange(details) : null;
    }
  };
  return (
    <div className="row gap-2">
      <MapMarker coordinates={cordinates} />
      <FieldWrapper error={error} label={label}>
        <Autocomplete
          onLoad={(autocomplete) => {
            autocompleteRef.current = autocomplete;
          }}
          onPlaceChanged={onPlaceChanged}
        >
          <input
            type="text"
            className="form-control"
            placeholder="Enter address"
            name="streetAddress"
            {...registration}
          />
        </Autocomplete>
      </FieldWrapper>
    </div>
  );
};
