import React, { useEffect } from 'react';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import { useSelectFile } from '@/hooks/useSelectFile';
import { Image } from '@/components/Elements/Image';
import { Spinner } from 'reactstrap';
import uploadFiles from '@/assets/uploadFiles.png';
import { nanoid } from 'nanoid';
type SingleImageUploder = {
  src: string;
  setImage: (img: string) => void;
  labbel?: string;
  error?: boolean;
};
export const SingleImageUploder = (props: SingleImageUploder) => {
  const id: string = nanoid();
  const { src, setImage, labbel, error } = props;
  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();
  useEffect(() => {
    if (uploaded && uploaded[0]) {
      setImage(uploaded[0]);
    }
  }, [images]);
  const handdleDelete = () => {
    deleteImage(0);
    setImage('');
  };
  return load ? (
    <div className="position-relative mb-3">
      <Spinner />
    </div>
  ) : src && src !== '' ? (
    <div className="relative w-36 h-36">
      <span
        onClick={handdleDelete}
        className="absolute top-2 right-2 bg-red-500 text-white rounded-full p-1 hover:bg-red-600 focus:outline-none"
      >
        X
      </span>
      <Image src={src} alt="image" />
    </div>
  ) : (
    <div className="position-relative mb-3">
      <div className="form-floating position-relative upload-files">
        <input type="file" name="uploadFiles" id={id} onChange={handleChange} />
        <span className="uploadFile">
          <img src={uploadFiles} alt="" className="d-block w-100" />
        </span>
        <label htmlFor={id}>{labbel}</label>
      </div>
      {error ? <span className="pt-4 tetx-sm capitalize text-red-500">Required.</span> : null}
    </div>
  );
};
