import clsx from 'clsx';
// import { useRef, useState } from 'react';
import { UseFormRegisterReturn } from 'react-hook-form';

import { FieldWrapper, FieldWrapperPassThroughProps } from './FieldWrapper';

const variants = {
  primary: '',
  secondary: 'bg-button',
};

type FileInputProps = FieldWrapperPassThroughProps & {
  className?: string;
  placeholder?: string;
  registration: Partial<UseFormRegisterReturn>;
  variant?: keyof typeof variants;
};

export const FileInput = (props: FileInputProps) => {
  const { label, variant = 'primary', className, registration, error, placeholder } = props;

  return (
    <FieldWrapper label={label} error={error}>
      <div className="form-floating">
        <input
          type="file"
          className={clsx(
            'form-control',
            error?.message && 'is-invalid',
            variants[variant],
            className
          )}
          placeholder={placeholder}
          {...registration}
        />
      </div>
    </FieldWrapper>
  );
};
