import * as React from 'react';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import ListItemText from '@mui/material/ListItemText';
import Select, { SelectChangeEvent } from '@mui/material/Select';
import Checkbox from '@mui/material/Checkbox';
import { Box } from '@mui/system';
import { Event } from '@/types';
import { Chip } from '@mui/material';

const ITEM_HEIGHT = 48;
const ITEM_PADDING_TOP = 8;
const MenuProps = {
  PaperProps: {
    style: {
      maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
      width: 250,
    },
  },
};

export default function MultiSelectField({
  events,
  defaultValue,
  eventName,
  setEventName,
}: {
  events: Event[];
  defaultValue: Event[];
  eventName: [];
  setEventName: any;
}) {
  const handleChange = (event: SelectChangeEvent<typeof eventName>) => {
    const {
      target: { value },
    } = event;

    setEventName(
      // On autofill we get a stringified value.
      typeof value === 'string' ? value.split(',') : value
    );
  };
  React.useEffect(() => {
    const ids = defaultValue.map((i) => i._id);
    setEventName(ids);
  }, [defaultValue, setEventName]);

  return (
    <div>
      <FormControl sx={{ m: 1, width: 300 }}>
        <InputLabel id="demo-multiple-checkbox-label">Tag</InputLabel>
        <Select
          labelId="demo-multiple-checkbox-label"
          id="demo-multiple-checkbox"
          multiple
          value={eventName}
          onChange={handleChange}
          input={<OutlinedInput label="Tag" />}
          renderValue={(selected) => {
            const eventNames = selected.map((i: string) => {
              const ev = events.find((j) => j._id === i);
              return ev?.name;
            });

            return (
              <Box sx={{ display: 'flex', flexWrap: 'wrap', gap: 0.5 }}>
                {eventNames.map((value, index) => (
                  <Chip key={index} label={value} />
                ))}
              </Box>
            );
          }}
          MenuProps={MenuProps}
        >
          {events?.map((event, index) => (
            <MenuItem key={index} value={event._id}>
              <Checkbox checked={eventName.indexOf(event._id) > -1} />
              <ListItemText primary={event.name} />
            </MenuItem>
          ))}
        </Select>
      </FormControl>
    </div>
  );
}
