import * as React from 'react';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import ListItemText from '@mui/material/ListItemText';
import Select, { SelectChangeEvent } from '@mui/material/Select';
import Checkbox from '@mui/material/Checkbox';
import { UseFormRegisterReturn } from 'react-hook-form';
import { FieldWrapper, FieldWrapperPassThroughProps } from './FieldWrapper';
import clsx from 'clsx';
const ITEM_HEIGHT = 48;
const ITEM_PADDING_TOP = 8;
const MenuProps = {
  PaperProps: {
    style: {
      maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
      width: 250,
    },
  },
};

type Option = {
  label: React.ReactNode;
  value: string | number | string[] | any;
};

type MultipleSelectFieldProps = FieldWrapperPassThroughProps & {
  options: Option[];
  placeholder?: string;
  className?: string;
  label: any;
  wrapperClass?: string;
  defaultValue?: any;
  registration: Partial<UseFormRegisterReturn>;
};
const MultipleSelectCheckmarks = (props: MultipleSelectFieldProps) => {
  const {
    placeholder,
    label,
    wrapperClass,
    options,
    error,
    className,
    defaultValue = '',
    registration,
  } = props;
  const [personName, setPersonName] = React.useState<string[]>([]);

  const handleChange = (event: SelectChangeEvent<typeof personName>) => {
    const {
      target: { value },
    } = event;
    setPersonName(
      // On autofill we get a stringified value.
      typeof value === 'string' ? value.split(',') : value
    );
  };

  return (
    <FieldWrapper className={wrapperClass ?? ''} label={label} error={error}>
      <div className="form-floating">
        <FormControl sx={{ m: 1, width: '100%' }}>
          <InputLabel id="demo-multiple-checkbox-label ">{label}</InputLabel>
          <Select
            labelId="demo-multiple-checkbox-label"
            id="demo-multiple-checkbox"
            multiple
            placeholder={placeholder}
            value={personName}
            onChange={handleChange}
            input={<OutlinedInput label={label} />}
            renderValue={(selected) => selected.join(', ')}
            MenuProps={MenuProps}
            className={clsx('form-floating', className)}
            defaultValue={defaultValue}
            {...registration}
          >
            {options.map(({ label, value }) => (
              <MenuItem key={label?.toString()} value={value}>
                <Checkbox checked={personName.indexOf(value) > -1} />
                <ListItemText primary={value} />
              </MenuItem>
            ))}
          </Select>
        </FormControl>
      </div>
    </FieldWrapper>
  );
};

export default MultipleSelectCheckmarks;
