import React, { useEffect, useState } from 'react';
import { Link } from 'react-router-dom';
import clsx from 'clsx';
import './userProfile.css';
import { useNotifications } from '@/api/Notification/getNotifications';
import { Notification } from '@/types';
import { useAuth } from '@/lib/auth';
import { timeFromNow } from '@/utils/format';

function NotificationContent({ item }: { item: Notification }) {
  return (
    <div role="button" tabIndex={-1} className="notify-box">
      <div className="note-list d-flex justify-content-between mb-2">
        <span className="d-flex f-13 align-items-center notification-content">{item.message}</span>
        <p className="light f-14 mb-0 text-center">{timeFromNow(item.date)} ago</p>
      </div>
    </div>
  );
}

const Notifications = () => {
  const { data, isLoading } = useNotifications();
  const [count, setCount] = useState(0);
  const { user } = useAuth();
  useEffect(() => {
    const countUnRead = data?.data?.filter((i) => !i.is_read).length ?? 0;
    setCount(countUnRead);
  }, [data]);
  const previewData = data?.data?.slice(0, 5);

  return (
    <div className="notification-drop">
      {!isLoading && (
        <div className="dropdown dropbottom">
          <button
            className="btn btn-secondary dropdown-toggle"
            type="button"
            id="dropdownMenuButton1"
            data-bs-toggle="dropdown"
            aria-expanded="false"
          >
            <i className="fa-regular fa-bell"></i>
            {count > 0 && (
              <span className="count">
                <span> count ={count}</span>
              </span>
            )}
          </button>
          <ul className="dropdown-menu" aria-labelledby="dropdownMenuButton1">
            <li
              className="header d-flex  align-items-center justify-content-between border-b"
              style={{ padding: '0 15px 10px 15px' }}
            >
              <p className="mb-0">
                <strong>Notifications</strong>
              </p>
              <div className="d-flex">
                <button className="dropdown-item orange" onClick={() => null}>
                  Read All
                </button>
                <Link className="dropdown-item" to={`/${user?.role}/notifications`}>
                  View All
                </Link>
              </div>
            </li>
            {previewData?.length === 0 && (
              <li className="nonotifications">No new notifications found</li>
            )}

            {previewData?.map((notification) => (
              <li
                key={notification.id}
                className={clsx('notification-item', !notification.is_read ? 'unread' : '')}
              >
                <NotificationContent item={notification} />
              </li>
            ))}
          </ul>
        </div>
      )}
    </div>
  );
};

export default Notifications;
