import React, { useEffect, useState } from 'react';
import { CardElement, useStripe, useElements } from '@stripe/react-stripe-js';
import './charge.css';
import cardpic from '@/assets/cardpic.svg';
import { useNavigate, useParams } from 'react-router-dom';
import { postSubscription } from '@/api/SubscriptionCustomer/postSubscription';
import storage from '@/utils/storage';

const ChargeForm = ({ price, discount }: { price: string; discount: number }) => {
  const stripe = useStripe();
  const elements = useElements();
  const [isLoading, setIsLoading] = useState(false);
  const navigate = useNavigate();
  const previousData = storage.getSubmitFormData();
  const nextPage = previousData?.pageUrl;

  const { idSub } = useParams();
  const [subscriptionId, setsubscriptionId] = useState<number>(0);

  const percentageOff = (price: number, percentageValue: number): number => {
    return price * (1 - percentageValue / 100);
  };

  const netPrice = percentageOff(parseInt(price), discount);

  const finalAmount = netPrice.toString().split('.');

  useEffect(() => {
    if (idSub) {
      setsubscriptionId(parseInt(idSub));
    }
  }, [idSub]);

  const handleSubmit = async (event: React.FormEvent) => {
    event.preventDefault();

    if (!stripe || !elements) {
      return;
    }

    setIsLoading(true);

    const cardElement = elements.getElement(CardElement);

    if (!cardElement) {
      return;
    }

    try {
      // Create a token using a test card
      const { token } = await stripe.createToken(cardElement, {
        currency: 'usd',
        name: 'Test User',
        address_line1: '123 Test Street',
        address_city: 'Test City',
        address_state: 'Test State',
        address_country: 'Test Country',
        address_zip: '12345',
      });

      if (token) {
        const cardToken = token?.id;
        const data = await postSubscription(subscriptionId, cardToken, finalAmount[0]);
        {
          if (data) {
            {
              nextPage ? navigate(nextPage) : navigate('/user/subscription');
            }
          }
        }
      }
    } finally {
      setIsLoading(false);
    }
  };

  return (
    <form onSubmit={handleSubmit} className="payment-form">
      <div className="form-row">
        <img src={cardpic} alt="sd" />
        <label htmlFor="card-element">Card Details</label>
        <CardElement
          id="card-element"
          options={{
            style: {
              base: {
                fontSize: '16px',
                fontFamily: 'Arial, sans-serif',
              },
            },
          }}
        />
        <button type="submit" disabled={!stripe || isLoading} className="pay-button">
          {isLoading ? 'Processing...' : 'Pay'}
        </button>
      </div>
    </form>
  );
};

export default ChargeForm;
