import React from 'react';
import { Elements } from '@stripe/react-stripe-js';
import { loadStripe } from '@stripe/stripe-js';

import ChargeForm from './ChargeForm';
import { useSearchParams } from 'react-router-dom';

export const ChargePayment = () => {
  const key = process.env.REACT_APP_STRIPE_KEY as string;

  const stripePromise = loadStripe(`${key}`);

  const [queryParams] = useSearchParams();
  const price: string = queryParams.get('price');
  const discount: number = queryParams.get('discount');

  return (
    <>
      <h3 className="pts">Pay Through Stripecvbvcb</h3>
      <Elements stripe={stripePromise}>
        <ChargeForm price={price} discount={discount} />
      </Elements>
    </>
  );
};
