import React, { useState } from 'react';

const Vipps = () => {
  const [amount, setAmount] = useState(100); // Set your desired payment amount
  const [orderId, setOrderId] = useState('your-unique-order-id'); // Generate a unique order ID

  const initiatePayment = async () => {
    try {
      // Send a request to your server to initiate the Vipps payment
      const response = await fetch('/api/vipps/initiate-payment', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ amount, orderId }),
      });

      if (response.ok) {
        const { url } = await response.json();

        // Redirect the user to the Vipps payment page
        window.location.href = url;
      } else {
        console.error('Failed to initiate Vipps payment');
      }
    } catch (error) {
      console.error('Error initiating Vipps payment:', error);
    }
  };

  return (
    <div>
      <h2>Pay with Vipps</h2>
      <p>Amount: {amount} NOK</p>
      <button onClick={initiatePayment}>Pay with Vipps</button>
    </div>
  );
};

export default Vipps;
