import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getBusinessDevloper = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/bussiness-developer-content');
};

export const postBusinessDevloper = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/bussiness-developer-content');
};

type QueryFnType = typeof getBusinessDevloper;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useBusinessDevloper = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getBusinessDevloper(),
  });
};
