import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getBusinessForSale = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/bussiness-for-sale-page');
};

export const postBusinessForSale = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/bussiness-for-sale-page');
};

type QueryFnType = typeof getBusinessForSale;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useBusinessForSale = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['BusinessForSale'],
    queryFn: () => getBusinessForSale(),
  });
};
