import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { ApiResponse, CommssionData } from '@/types';

export const getCommission = (): Promise<ApiResponse<CommssionData>> => {
  return axios.get('/admin-api/manage-commission');
};

type QueryFnType = typeof getCommission;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useCommission = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['commission'],
    queryFn: () => getCommission(),
  });
};
