import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { InvestmentCompany } from '@/types';

export const CompanyInvestmentList = (
  pagination: PaginationQuery
): Promise<TableResponse<InvestmentCompany>> => {
  return axios.get(url('admin-api/investment-company-list', pagination));
};

type QueryFnType = typeof CompanyInvestmentList;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useCompanyInvestmentList = ({
  config,
  page_per_data = '10',
  page,
}: UseBusinessOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Company-Investment-List'],
    queryFn: () => CompanyInvestmentList({ page_per_data, page }),
  });
};
