import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';

export const Dashboard = () => {
  return axios.get('/admin-api/admin-dashboard');
};

type QueryFnType = typeof Dashboard;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useDashboard = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => Dashboard(),
  });
};
