import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Property } from '@/types';

export const GetRentAdmin = (id: string): Promise<ApiResponse<Property>> => {
  return axios.get(`/admin-api/sale-property-details?id=${id}`);
};

type QueryFnType = typeof GetRentAdmin;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useGetRentAdminDetails = ({ config, id }: UseHousingOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['GetRentAdmin-detail'],
    queryFn: () => GetRentAdmin(id),
  });
};
