import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getHowItWorks = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/how-it-work-content');
};

export const postHowItWorks = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/how-it-work-content');
};

type QueryFnType = typeof getHowItWorks;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useHowItWorks = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getHowItWorks(),
  });
};
