import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getPropertySale = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/property-sale-rent-page');
};

export const postPropertySale = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/property-sale-rent-page');
};

type QueryFnType = typeof getPropertySale;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const usePropertySale = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getPropertySale(),
  });
};
