import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getSaleCondition = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/sale-condition-page');
};

export const postSaleCondition = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/sale-condition-page');
};

type QueryFnType = typeof getSaleCondition;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const useSaleCondition = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getSaleCondition(),
  });
};
