import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Subscription } from '@/types';
export const GetSubscription = (pagination: PaginationQuery): Promise<Subscription[]> => {
  return axios.get(url('/subscription-api/plan-listing', pagination));
};
type QueryFnType = typeof GetSubscription;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useSubscription = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['listing'],
    queryFn: () => GetSubscription({ page_per_data, page }),
  });
};
