import { axios } from '@/lib/axios';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { AxiosResponse } from 'axios';

export type AgencyPlans = {
  id: string;
  plan_name: string;
  plan_validity: string;
  price: string;
  plan_description: string;
  status: boolean;
  tier_type: number;
};

export const getAgencyPlansList = (
  pagination: PaginationQuery
): Promise<AxiosResponse<AgencyPlans[]>> => {
  return axios.get(url(`/subscription-api/agency-plan-listing`, pagination));
};

type QueryFnType = typeof getAgencyPlansList;

type useAgencyPlansList = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useAgencyPlansList = ({ config, page_per_data = '10', page }: useAgencyPlansList) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agencyPlansListing'],
    queryFn: () => getAgencyPlansList({ page_per_data, page }),
  });
};
