import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { LawyerSubscriptionValue } from '../../routes/Subscription/EditLawyerSubscription';
import { AxiosResponse } from 'axios';

export const getLawyerById = (id: string): Promise<AxiosResponse<LawyerSubscriptionValue>> => {
  return axios.get(`/subscription-api/lawyer-plan-details?id=${id}`);
};

type QueryFnType = typeof getLawyerById;
type UseAgencyOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useLawyerById = ({ config, id }: UseAgencyOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-plan-detail'],
    queryFn: () => getLawyerById(id),
  });
};
