import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Subscription } from '@/types';

export const getSubId = (id: string): Promise<ApiResponse<Subscription>> => {
  return axios.get(`/subscription-api/get-plan-detail?id=${id}`);
};

type QueryFnType = typeof getSubId;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useSubId = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['bfs-detail'],
    queryFn: () => getSubId(id),
  });
};
