import { axios } from '@/lib/axios';
import { API_URL } from '@/config';

export type ResetDTO = {
  old_password: string;
  new_password: string;
  confirm_password: string;
};

export const changePassword = (data: ResetDTO) => {
  return axios.post(`${API_URL}admin-api/admin-change-password`, {
    old_password: data.old_password,
    new_password: data.new_password,
    confirm_password: data.confirm_password,
  });
};
