import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, FaqContent } from '@/types';

export const faqData = (): Promise<ApiResponse<FaqContent>> => {
  return axios.get(`/admin-api/faq-listing`);
};

type QueryFnType = typeof faqData;

type UseFaqOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useFaqData = ({ config }: UseFaqOptions = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['faq-detail'],
    queryFn: () => faqData(),
  });
};
